<?php
require_once __DIR__ . '/../PHPToolkit/NetSuiteService.php';


function searchByRFC($rfc){
    $service = new NetSuiteService();
    // Crea un objeto SearchStringCustomField para especificar el valor del campo personalizado
    $searchField = new SearchStringCustomField();
    $searchField->scriptId = "custentity_mx_rfc"; // Reemplaza con el scriptId del campo personalizado
    $searchField->operator = "is"; // Puedes ajustar el operador según tus necesidades (ejemplo: "is" para igual)
    $searchField->searchValue = $rfc; // Reemplaza con el valor que deseas buscar en el campo personalizado

    // Crea un objeto CustomerSearchBasic para buscar clientes que cumplan con el criterio
    $search = new CustomerSearchBasic();
    $search->customFieldList = new SearchCustomFieldList();
    $search->customFieldList->customField = array($searchField);

    // Realiza la búsqueda de clientes
    $request = new SearchRequest();
    $request->searchRecord = $search;

    $searchResponse = $service->search($request);
    if (!$searchResponse->searchResult->status->isSuccess) {
        error_log("Error en la búsqueda: " . $searchResponse->searchResult->status->statusDetail[0]->message);
    } else {
        $searchResults = $searchResponse->searchResult->recordList;
        if (!empty($searchResults)) {
            // Se encontraron registros que coinciden con el criterio
            //error_log(print_r('Error: '.json_encode($searchResults), TRUE));
            return $searchResults->record;
        } else {
            return null;
        }
    }
    return null;
}
function searchByEmail($email){
    $service = new NetSuiteService();
    $service->setSearchPreferences(false, 20);

    $emailSearchField = new SearchStringField();
    $emailSearchField->operator = "is";
    $emailSearchField->searchValue = $email;

    $search = new CustomerSearchBasic();
    $search->email = $emailSearchField;

    $request = new SearchRequest();
    $request->searchRecord = $search;

    $searchResponse = $service->search($request);

    
    
    
    if (!$searchResponse->searchResult->status->isSuccess) {
        error_log("Error en la búsqueda: " . $searchResponse->searchResult->status->statusDetail[0]->message);
    } else {
        $searchResults = $searchResponse->searchResult->recordList;
        
        if (!empty($searchResults)) {
            // Se encontraron registros que coinciden con el criterio
            //error_log(print_r('Error: '.json_encode($searchResults), TRUE));
            return $searchResults->record;
        } else {
            return null;
        }
    }
    return null;
}
?>