<?php
    require_once __DIR__ . '/../PHPToolkit/NetSuiteService.php';
    require_once __DIR__ . '/../models/InvoiceHelper.php';
    
    use Models\InvoiceHelper;

    function createCustomer($data){
        $service = new NetSuiteService();
    
        $customer = new Customer();


        error_log(print_r('crud: '.json_encode($data), TRUE));
        
        $customer->firstName = $data["firstName"];
        $customer->lastName = $data["lastName"];
        $customer->email = $data["email"];
        $customer->phone = $data["phone"];
        $customer->isPerson = true;
        $customer->customForm = new RecordRef();
        $customer->customForm->internalId = $data["customFormCustomer"];//344
        $customer->entityStatus = new RecordRef();
        $customer->entityStatus->internalId = $data["customerEntityStatus"];//13
        $customer->subsidiary = new RecordRef();
        $customer->subsidiary->internalId = $data["subsidiary"];//2


        $addressbookList = new CustomerAddressbookList();
        
        $address = new Address();
        //$address->addr1 = $data["address"];
        //$address->addr2 = $data["address2"];
        $address->city = $data["city"];
        $address->state = $data["state"];
        $address->country = "_mexico";
        $address->zip = $data["zip"];

        $customAddress = new StringCustomFieldRef();
        $customAddress->scriptId = "custrecord_streetname";
        $customAddress->value = $data["address"];

        $customNumber = new StringCustomFieldRef();
        $customNumber->scriptId = "custrecord_streetnum";
        $customNumber->value = $data["address2"];

        $customFieldList = new CustomFieldList();
        $customFieldList->customField = array($customAddress, $customNumber);

        $address->customFieldList = $customFieldList;

        $addressbook = new CustomerAddressBook();
        $addressbook->addressbookAddress = $address;
        $addressbook->defaultBilling = true;
        $addressbook->defaultShipping = true;

        $addressbookList->addressbook = $addressbook;
        $customer->addressbookList = $addressbookList;

        $customField1 = new StringCustomFieldRef();
        $customField1->scriptId = "custentity_mx_rfc";
        $customField1->value = $data["rfc"];

        $customField2 = new StringCustomFieldRef();
        $customField2->scriptId = "custentity_mx_sat_industry_type";
        $customField2->value = $data["satIndustry"];//15;

        $customField3 = new StringCustomFieldRef();
        $customField3->scriptId = "custentity_mx_sat_registered_name";
        $customField3->value = $data["satName"];

        $customField4 = new StringCustomFieldRef();
        $customField4->scriptId = "custentity_psg_ei_entity_edoc_standard";
        $customField4->value = $data["customerEntityDoc"];

        

        $customFieldList = new CustomFieldList();
        $customFieldList->customField = array($customField1, $customField2, $customField3, $customField4);

        $customer->customFieldList = $customFieldList;

        if(isset($data["rfc"])){
            $customerTaxRegistration = new CustomerTaxRegistration();
            $customerTaxRegistration->nexusCountry = "_mexico";
            $customerTaxRegistration->taxRegistrationNumber = $data["rfc"];
            
            

            $customerTaxRegistrationList = new CustomerTaxRegistrationList();
            $customerTaxRegistrationList->customerTaxRegistration = array($customerTaxRegistration);

            
            $customer->taxRegistrationList = $customerTaxRegistrationList;
        }

        $request = new AddRequest();
        $request->record = $customer;

        $addResponse = $service->add($request);

        if (!$addResponse->writeResponse->status->isSuccess) {
            //echo "ADD ERROR";
            error_log(print_r('error cliente: '.json_encode($addResponse), TRUE));
            return null;
        } else {
            error_log(print_r('cliente: '.$addResponse->writeResponse->baseRef->internalId, TRUE));
            return $addResponse->writeResponse->baseRef->internalId;
            
            //echo "ADD SUCCESS, id " . $addResponse->writeResponse->baseRef->internalId;
        }

    
    }

    function updateCustomer($data, $id){
        $service = new NetSuiteService();

        $customer = new Customer();

        error_log(print_r('crud: '.json_encode($data), TRUE));
        
        $customer->firstName = $data["firstName"];
        $customer->lastName = $data["lastName"];
        $customer->email = $data["email"];
        $customer->phone = $data["phone"];
        $customer->isPerson = true;
        $customer->customForm = new RecordRef();
        $customer->customForm->internalId = $data["customFormCustomer"];//344
        $customer->entityStatus = new RecordRef();
        $customer->entityStatus->internalId = $data["customerEntityStatus"];//13
        $customer->subsidiary = new RecordRef();
        $customer->subsidiary->internalId = $data["subsidiary"];//2

        $customer->internalId = $id;


        $addressbookList = new CustomerAddressbookList();
        
        $address = new Address();
        //$address->addr1 = $data["address"];
        //$address->addr2 = $data["address2"];
        $address->city = $data["city"];
        $address->state = $data["state"];
        $address->country = "_mexico";
        $address->zip = $data["zip"];


        $customAddress = new StringCustomFieldRef();
        $customAddress->scriptId = "custrecord_streetname";
        $customAddress->value = $data["address"];

        $customNumber = new StringCustomFieldRef();
        $customNumber->scriptId = "custrecord_streetnum";
        $customNumber->value = $data["address2"];

        $customFieldList = new CustomFieldList();
        $customFieldList->customField = array($customAddress, $customNumber);

        $address->customFieldList = $customFieldList;


        $addressbook = new CustomerAddressBook();
        $addressbook->addressbookAddress = $address;
        $addressbook->defaultBilling = true;
        $addressbook->defaultShipping = true;

        $addressbookList->addressbook = $addressbook;
        $customer->addressbookList = $addressbookList;


        $customField1 = new StringCustomFieldRef();
        $customField1->scriptId = "custentity_mx_rfc";
        $customField1->value = $data["rfc"];

        $customField2 = new StringCustomFieldRef();
        $customField2->scriptId = "custentity_mx_sat_industry_type";
        $customField2->value = $data["satIndustry"];//15;

        $customField3 = new StringCustomFieldRef();
        $customField3->scriptId = "custentity_mx_sat_registered_name";
        $customField3->value = $data["satName"];

        $customField4 = new StringCustomFieldRef();
        $customField4->scriptId = "custentity_psg_ei_entity_edoc_standard";
        $customField4->value = $data["customerEntityDoc"];

        $customFieldList = new CustomFieldList();
        $customFieldList->customField = array($customField1, $customField2, $customField3, $customField4);

        $customer->customFieldList = $customFieldList;


        $customerTaxRegistration = new CustomerTaxRegistration();
        $customerTaxRegistration->nexusCountry = "_mexico";
        $customerTaxRegistration->taxRegistrationNumber = $data["rfc"];
        

        
        

        $customerTaxRegistrationList = new CustomerTaxRegistrationList();
        $customerTaxRegistrationList->customerTaxRegistration = array($customerTaxRegistration);

        
        $customer->taxRegistrationList = $customerTaxRegistrationList;

        $request = new UpdateRequest();
        $request->record = $customer;

        $addResponse = $service->update($request);

        if (!$addResponse->writeResponse->status->isSuccess) {
            //echo "ADD ERROR";
            error_log(print_r('error cliente: '.json_encode($addResponse), TRUE));
            return null;
        } else {
            error_log(print_r('cliente: '.$addResponse->writeResponse->baseRef->internalId, TRUE));
            return $addResponse->writeResponse->baseRef->internalId;
            
            //echo "ADD SUCCESS, id " . $addResponse->writeResponse->baseRef->internalId;
        }
    }
    
    function generateInvoice(InvoiceHelper $invoiceData){
        $service = new NetSuiteService();

        error_log(print_r('invoice: '.json_encode($invoiceData), TRUE));

        $invoice = new Invoice();
        $invoice->entity = new RecordRef();
        $invoice->entity->internalId = $invoiceData->customerId; // ID del cliente
        $invoice->location = new RecordRef();
        $invoice->location->internalId = $invoiceData->locationId; // ID de la ubicación
        $invoice->department = new RecordRef();
        $invoice->department->internalId = $invoiceData->departmentId; // ID de la departamento
        $invoice->account = new RecordRef();
        $invoice->account->internalId = $invoiceData->accountId; // ID de la departamento
        $invoice->class = new RecordRef();
        $invoice->class->internalId = $invoiceData->classId; // ID de la departamento
        $invoice->terms = new RecordRef();
        $invoice->terms->internalId = $invoiceData->termsId; // ID de la departamento
        
        $invoice->subsidiary = new RecordRef();
        $invoice->subsidiary->internalId = $invoiceData->subsidiary;

        $item = new InvoiceItem();
        $item->item = new RecordRef();
        $item->item->internalId = $invoiceData->itemId;
        $item->amount = $invoiceData->amount;
        $item->rate = $invoiceData->amount;

        $customFieldListItem = new CustomFieldList();
        $customFieldItem = new StringCustomFieldRef();
        $customFieldItem->scriptId = "custcol_mx_txn_line_sat_tax_object";
        $customFieldItem->value = 1;
        $customFieldListItem->customField = array($customFieldItem);

        $item->customFieldList = $customFieldListItem;

        $invoice->itemList = new InvoiceItemList();
        $invoice->itemList->item = array($item);

        $customFieldList = new CustomFieldList();
        $customField1 = new BooleanCustomFieldRef();
        $customField1->scriptId = "custbody_edoc_gen_trans_pdf";
        $customField1->value = true;
        
        
        $customField2 = new StringCustomFieldRef();
        $customField2->scriptId = "custbody_mx_cfdi_usage";
        $customField2->value = $invoiceData->cfdiUsageId;


        $customField3 = new StringCustomFieldRef();
        $customField3->scriptId = "custbody_mx_txn_sat_payment_term";
        $customField3->value = "3";

        
        $customField4 = new StringCustomFieldRef();
        $customField4->scriptId = "custbody_psg_ei_template";
        $customField4->value = $invoiceData->custbody_psg_ei_template; //9
        $customFieldList->customField = array($customField1, $customField2, $customField3, $customField4);
        
        //$customFieldList->customField = array($customField1, $customField2, $customField3); //ESTO ES PARA CUANDO NO SE SELECCIONA EL DOCUMENTO PARA TIMBRAR
        
        

        $invoice->customFieldList = $customFieldList;

        $invoice->tranDate = date('c'); // Fecha de la factura (hoy)
        $invoice->currency = new RecordRef();
        $invoice->currency->internalId = 1; 

        $request = new AddRequest();
        $request->record = $invoice;

        $addResponse = $service->add($request);

        if (!$addResponse->writeResponse->status->isSuccess) {
            //echo "ADD ERROR";
            error_log(print_r('Invoice: '.json_encode($addResponse), TRUE));
            return null;
        } else {
            return $addResponse->writeResponse->baseRef->internalId;
            //echo "ADD SUCCESS, id " . $addResponse->writeResponse->baseRef->internalId;
        }

        
    }
    function generateBillOrder($vendorBillInfo){
    //function generateBillOrder($vendorBillInfo, $comisionStripe, $docRef){
        $service = new NetSuiteService();

        $vendorBill = new VendorBill();
        $vendorBill->entity = new RecordRef();
        $vendorBill->entity->internalId = $vendorBillInfo->vendorId;//530;//$beneficiarioProveedor
        $vendorBill->account = new RecordRef();
        $vendorBill->account->internalId = $vendorBillInfo->account;//569;
        $vendorBill->customForm = new RecordRef();
        $vendorBill->customForm->internalId = $vendorBillInfo->formVendor;//421; //$formularioOrden
        $vendorBill->subsidiary = new RecordRef();
        $vendorBill->subsidiary->internalId = $vendorBillInfo->subsidiary;//2;
        $vendorBill->memo = $vendorBillInfo->memo;//"Factura creada desde stripe";
        $vendorBill->location = new RecordRef();
        $vendorBill->location->internalId = $vendorBillInfo->location;//1;
        $vendorBill->currency = new RecordRef();
        $vendorBill->currency->internalId = $vendorBillInfo->currency;//1;
        $vendorBill->exchangeRate = 1.0;
        $vendorBill->class = new RecordRef();
        $vendorBill->class->internalId =$vendorBillInfo->class; //105;
        
        $item = new VendorBillItem();
        $item->item = new RecordRef();
        $item->item->internalId = $vendorBillInfo->itemId;//123;
        $item->class = new RecordRef();
        $item->class->internalId =$vendorBillInfo->class; //105;
        $item->department = new RecordRef();
        $item->department->internalId = $vendorBillInfo->department;//308;
        $item->amount = $vendorBillInfo->amount;//$comisionStripe;

        $vendorBill->itemList = new VendorBillItemList();
        $vendorBill->itemList->item = array($item);

        $vendorBill->tranId = $vendorBillInfo->docRef;//$docRef;

        $request = new AddRequest();
        $request->record = $vendorBill;

        $addResponse = $service->add($request);

        if (!$addResponse->writeResponse->status->isSuccess) {
            //echo "ADD ERROR";
            error_log(print_r('Vendor Bill: '.json_encode($addResponse), TRUE));
            return null;
        } else {
            error_log(print_r('Vendor Bill generated: '.json_encode($addResponse->writeResponse), TRUE));

            return $addResponse->writeResponse->baseRef->internalId;
            //echo "ADD SUCCESS, id " . $addResponse->writeResponse->baseRef->internalId;
        }

    }
    function generatePaymentBill($vendorPaymentInfo){
        $service = new NetSuiteService();

        $vendorPayment = new VendorPayment();
        $vendorPayment->apAcct = new RecordRef();
        $vendorPayment->apAcct->internalId = $vendorPaymentInfo->appAccount;//569;
        $vendorPayment->customForm = new RecordRef();
        $vendorPayment->customForm->internalId = $vendorPaymentInfo->formPayment;//410; //$formularioPayment
        $vendorPayment->entity = new RecordRef();
        $vendorPayment->entity->internalId = $vendorPaymentInfo->vendorId;//530; //$beneficiarioProveedor
        $vendorPayment->subsidiary = new RecordRef();
        $vendorPayment->subsidiary->internalId = $vendorPaymentInfo->subsidiary;//2;
        $vendorPayment->account = new RecordRef();
        $vendorPayment->account->internalId = $vendorPaymentInfo->account;//835; //$cuentaPagarProveedor
        $vendorPayment->currency = new RecordRef();
        $vendorPayment->currency->internalId = $vendorPaymentInfo->currency;//1;
        $vendorPayment->exchangeRate = 1.0;
        $vendorPayment->class = new RecordRef();
        $vendorPayment->class->internalId = $vendorPaymentInfo->class;//105;
        $vendorPayment->department = new RecordRef();
        $vendorPayment->department->internalId = $vendorPaymentInfo->department;//308;
        $vendorPayment->location = new RecordRef();
        $vendorPayment->location->internalId = $vendorPaymentInfo->location;//1;

        $apply = new VendorPaymentApply();
        $apply->apply = true;
        $apply->doc = $vendorPaymentInfo->billOrder;//$billOrder;
        $apply->amount = $vendorPaymentInfo->amount;//$amountOrder;
        

        $vendorPayment->applyList = new VendorPaymentApplyList();
        $vendorPayment->applyList->apply = array($apply);


        $request = new AddRequest();
        $request->record = $vendorPayment;

        $addResponse = $service->add($request);

        if (!$addResponse->writeResponse->status->isSuccess) {
            //echo "ADD ERROR";
            error_log(print_r('Vendor Payment Id: '.json_encode($addResponse), TRUE));
            return null;
        } else {
            error_log(print_r('Vendor Payment Id: '.json_encode($addResponse->writeResponse), TRUE));
            return $addResponse->writeResponse->baseRef->internalId;
            //echo "ADD SUCCESS, id " . $addResponse->writeResponse->baseRef->internalId;
        }

    }
?>