<?php

namespace Services;

require_once __DIR__ . '/../vendor/autoload.php'; // Asegúrate de cargar el autoload de Composer

use Dotenv\Dotenv;
use Stripe\Stripe;
use Stripe\Webhook;


class StripeService
{
    private $dotenv;
    
    private $stripeSecretKey;
    public function __construct()
    {
        $this->dotenv = Dotenv::createImmutable(__DIR__ . '/../');
        $this->dotenv->load();
        $this->stripeSecretKey = $_ENV['STRIPE_SECRET_KEY'];
        Stripe::setApiKey($this->stripeSecretKey);
    }

    public function validateWebhook($payload, $sigHeader)
    {
        $endpointSecret = $_ENV['STRIPE_WEBHOOK_SECRET'];

        try {
            return Webhook::constructEvent($payload, $sigHeader, $endpointSecret);
        } catch (\UnexpectedValueException $e) {
            throw new \Exception('Invalid payload');
        } catch (\Stripe\Exception\SignatureVerificationException $e) {
            throw new \Exception('Invalid signature');
        }
    }

    // Puedes añadir más métodos para manejar PaymentIntents, Subscriptions, etc.
}

