<?php
    require_once 'secrets.php';
    require_once 'tools.php';
    require_once 'vendor/autoload.php';
    require_once 'models/InvoiceHelper.php';
    require_once 'models/VendorBillHelper.php';
    require_once 'models/VendorPaymentHelper.php';
    require_once 'netsuite/seach.php';
    require_once 'netsuite/crud.php';
    require 'Mailer.php';
    \Stripe\Stripe::setApiKey($stripeSecretKey);
    $stripe = new \Stripe\StripeClient($stripeSecretKey);

    $date = date('Y/m/d H:i:s');

    error_log("Entra a archivo");

    $usoCfdiList = array(
        -1 => "- Nuevo -",
        25 => "CN01 - Nómina",
        24 => "CP01 - Pagos",
        12 => "D01 - Honorarios Médicos, Dentales y Gastos Hospitalarios",
        13 => "D02 - Gastos Médicos por Incapacidad o Discapacidad",
        14 => "D03 - Gastos Funerales",
        15 => "D04 - Donativos (no aplica para membresía)",
        16 => "D05 - Intereses Reales Efectivamente Pagados por Créditos Hipotecarios (Casa Habitación)",
        17 => "D06 - Aportaciones Voluntarias al SAR",
        18 => "D07 - Primas por Seguros de Gastos Médicos",
        19 => "D08 - Gastos de Transportación Escolar Obligatoria",
        20 => "D09 - Depósitos en Cuentas para el Ahorro, Primas que Tengan como Base Planes de Pensiones",
        21 => "D10 - Pagos por Servicios Educativos (Colegiaturas)",
        1 => "G01 - Adquisición de Mercancías",
        2 => "G02 - Devoluciones, Descuentos o Bonificaciones",
        3 => "G03 - Gastos en General",
        4 => "I01 - Construcciones",
        5 => "I02 - Mobiliario y Equipo de Oficina por Inversiones",
        6 => "I03 - Equipo de Transporte",
        7 => "I04 - Equipo de Cómputo y Accesorios",
        8 => "I05 - Dados, Troqueles, Moldes, Matrices y Herramental",
        9 => "I06 - Comunicaciones Telefónicas",
        10 => "I07 - Comunicaciones Satelitales",
        11 => "I08 - Otra Maquinaria y Equipo",
        22 => "P01 - Por Definir",
        23 => "S01 - Sin efectos fiscales"
    );
    
    $regimenList = array(
        1 => "601 - General de Ley Personas Morales",
        2 => "603 - Personas Morales con Fines no Lucrativos",
        11 => "605 - Sueldos y Salarios e Ingresos Asimilados a Salarios",
        12 => "606 - Arrendamiento",
        10 => "607 - Régimen de Enajenación o Adquisición de Bienes",
        13 => "608 - Demás ingresos",
        4 => "610 - Residentes en el Extranjero sin Establecimiento Permanente en México",
        14 => "611 - Ingresos por Dividendos (socios y accionistas)",
        15 => "612 - Personas Físicas con Actividades Empresariales y Profesionales",
        16 => "614 - Ingresos por intereses",
        19 => "615 - Régimen de los ingresos por obtención de premios",
        17 => "616 - Sin obligaciones fiscales",
        5 => "620 - Sociedades Cooperativas de Producción que Optan por Diferir sus Ingresos",
        18 => "621 - Incorporación Fiscal",
        6 => "622 - Actividades Agrícolas, Ganaderas, Silvícolas Y Pesqueras",
        7 => "623 - Opcional para Grupos de Sociedades",
        8 => "624 - Coordinados",
        22 => "625 - Régimen de las Actividades Empresariales con ingresos a través de Plataformas Tecnológicas",
        23 => "626 - Régimen Simplificado de Confianza"
    );
    $url_base = "https://auna.nationbuilder.com";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        $event = \Stripe\Event::constructFrom(
            json_decode($payload, true)
        );
    } catch(\UnexpectedValueException $e) {
        // Invalid payload
        http_response_code(400);
        exit();
    }
    $session = $event->data->object; 
    //$session = $jsonData->data->object; 

        // Accede a los metadatos aquí
        $json_data = json_encode($session);
        $escaped_json_data = escapeshellarg($json_data);

    error_log(print_r('data NB: '.json_encode($jsonData), TRUE));

    //$session = json_decode($argumentos);
    


    $metadata = $session->metadata;

        $firstName = $metadata->firstName;
        $lastName = $metadata->lastName;
        $amount = $metadata->amount;
        $email = $metadata->email;
        $phone = $metadata->phone;
        $country = $metadata->country;
        $address = $metadata->address;
        $address2 = $metadata->address2;
        $zip = $metadata->zip;
        $rfc = $metadata->rfc;
        $city = $metadata->city;
        $state = $metadata->state;
        $satName = $metadata->satName;
        $pageSlug = $metadata->pageSlug;

        //$taxAddress = $metadata->taxAddress;
        $taxAddress = "";
        $taxRegime = $metadata->taxRegime;
        $cfdiUse = $metadata->cfdiUse;
        $currentDate = date("Y-m-d H:i:s");
        $isTest = $metadata->isTest;

        $itemInvoice = $item;
        $classInvoice = $class;
        $departmentInvoice = $department;

        $template = $custbody_psg_ei_template;
        if(isset($metadata->itemMembresia)){
            $itemInvoice = $metadata->itemMembresia;
        }
        if(isset($metadata->classMembresia)){
            $classInvoice = $metadata->classMembresia;
        }
        if(isset($metadata->departmentMembresia)){
            $departmentInvoice = $metadata->departmentMembresia;
        }
        if(isset($metadata->templateCFDI)){
            $template = $metadata->templateCFDI;
        }

        $isMembership = 0;
        if(isset($metadata->isMembership)){
            if($metadata->isMembership){
                $isMembership = 1;
            }
            
        }


        try{
            $urlBuscar = $url_base.'/api/v1/people/push'.'?access_token='.$tokenNB;

            $dataPerson = array(
                'person' => array(
                    'email' => $email,
                    'first_name' => $firstName,
                    'last_name' => $lastName,
                    'phone' => $phone,
                    'billing_address' => array(
                        'address1' => $address,
                        'address2' => $address2,
                        'city' => $city,
                        'state' => $state,
                        'country_code' => $country,
                        'zip' => $zip
                    )
                    
                )
            );
    
            $personJson = json_encode($dataPerson);
            
            $ch = curl_init($urlBuscar);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $personJson);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json'
            ));
    
            $resultado = curl_exec($ch);
    
            if ($resultado === false) {
                error_log("[".$date."] Error al ejecutar la solicitud: " . curl_error($ch));
            } else {
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            
                if ($httpCode == 200 || $httpCode == 201) {
                    $respuesta = json_decode($resultado, true);
    
                    if(isset($respuesta["person"]["id"])){
                        $idPerson = $respuesta["person"]["id"];
                        error_log("id person encontrado: ".$idPerson );

                        $hasTag = false;
                        $tags = $respuesta["person"]["tags"];

                                
                        foreach ($tags as $elemento) {
                            if ($tags == "MembresiaNueva24") {
                                $hasTag = true;
                                error_log("Tag encontrado");
                                break;
                            }
                        }

                        if($hasTag == false){
                            $urlTags = $url_base.'/api/v1/people/'.$idPerson.'/taggings'.'?access_token='.$tokenNB;
                                                    
                            $tagData = array(
                                'tagging' => array(
                                    'tag' => 'MembresiaNueva24'
                                )
                            );
        
                            
                            $tagJson = json_encode($tagData);
        
                            $ch = curl_init($urlTags);
                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
                            curl_setopt($ch, CURLOPT_POSTFIELDS, $tagJson);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                                'Content-Type: application/json'
                            ));
        
                            $resultado = curl_exec($ch);
        
                            if ($resultado === false) {
                                error_log("[".$date."] Error al ejecutar la solicitud: " . curl_error($ch));
                            } else {
                                echo "Código de Respuesta: $codigoRespuesta\n";
                                echo "Cuerpo de la Respuesta: $resultado\n";
                            }
                        }

                            $urlDonacion = $url_base.'/api/v1/donations'.'?access_token='.$tokenNB;
                            $zona_horaria = date_default_timezone_get();
        
                            $fecha_actual = date('Y-m-d\TH:i:s', time()) . date('P');
        
                            $donacionData = array(
                                'donation' => array(
                                    'donor_id' => $idPerson,
                                    'amount_in_cents' => $amount*100,
                                    'payment_type_name' => 'Credit Card',
                                    'succeeded_at' => $fecha_actual,
                                    'page_slug' => $pageSlug,
                                    'custom_values' => array(
                                        'rfc' => $rfc,
                                        'direccion_fiscal' => isset($taxAddress) ? $taxAddress : null,
                                        'r_gimen_fiscal' => isset($taxRegime) ? $taxRegime : null,
                                        'uso_cfdi' => isset($cfdiUse) ? $cfdiUse : null
                                    )
                                )
                            );
        
                            
                            $donacionJson = json_encode($donacionData);
        
                            $ch = curl_init($urlDonacion);
                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                            curl_setopt($ch, CURLOPT_POSTFIELDS, $donacionJson);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                                'Content-Type: application/json'
                            ));
        
                            $resultado = curl_exec($ch);
        
                            if ($resultado === false) {
                                error_log("[".$date."] Error al ejecutar la solicitud: " . curl_error($ch));
                            } else {
                                $codigoRespuesta = curl_getinfo($ch, CURLINFO_HTTP_CODE);

                                echo "Código de Respuesta: $codigoRespuesta\n";
                                echo "Cuerpo de la Respuesta: $resultado\n";
                            }

                        if($isMembership == 1){
                            $urlMembresia = $url_base.'/api/v1/people/'.$idPerson.'/memberships?access_token='.$tokenNB;
                            $zona_horaria = date_default_timezone_get();
        
                            $fecha_actual = date('Y-m-d\TH:i:s', time()) . date('P');

                            $fechaExpiracion = new DateTime();

                            
                            $fechaExpiracion->modify('+1 year');


                            $fechaExpiracion = $fechaExpiracion->format('Y-m-d\TH:i:sP');

        
                            $membershipData = array(
                                'membership' => array(
                                    'name' => 'Aúna',
                                    'status' => 'active',
                                    'status_reason' => 'paid',
                                    'started_at' => $fecha_actual,
                                    'expires_on' => $fechaExpiracion
                                )
                            );
        
                            
                            $membresiaJson = json_encode($membershipData);
        
                            $ch = curl_init($urlMembresia);
                            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                            curl_setopt($ch, CURLOPT_POSTFIELDS, $membresiaJson);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                                'Content-Type: application/json'
                            ));
        
                            $resultado = curl_exec($ch);
        
                            if ($resultado === false) {
                                error_log("[".$date."] Error al ejecutar la solicitud: " . curl_error($ch));
                            } else {
                                $codigoRespuesta = curl_getinfo($ch, CURLINFO_HTTP_CODE);

                                echo "Código de Respuesta: $codigoRespuesta\n";
                                echo "Cuerpo de la Respuesta: $resultado\n";
                            }
                        }
    
                        
    
                    }else{
                        error_log("Hubo un erro al crear al usuario. Datos capturados: ".json_encode($dataPerson));
                    }
                } else {
                    // Hubo un error en la solicitud
                    error_log("[".$date."] Error en la solicitud. Código de respuesta HTTP: " . $httpCode);
                }
            }
            curl_close($ch);
        }catch(Exception $err){
            error_log(print_r('error: '.json_encode($error), TRUE));
        }

    try{

    }catch(Exception $error){
        error_log(print_r('error: '.json_encode($error), TRUE));
    }


    http_response_code(200);
    echo json_encode($jsonData);
}else{
    echo $_GET['code'];
    error_log('code: '.$_GET['code']);
}
?>