<?php
    function get_signature( $url, $consumer_key, $consumer_secret, $method = 'GET', $params = false ) {
        $nonce     = mt_rand();
        $timestamp = time();
        $oauth     = new \OAuth( $consumer_key, $consumer_secret );
        $oauth->setTimestamp( $timestamp );
        $oauth->setNonce( $nonce );
        $sig = $oauth->generateSignature( $method, $url, $params );
  
        $header = 'OAuth ' .
            'oauth_consumer_key=' . $consumer_key .
            ',oauth_signature_method="HMAC-SHA1"' .
            ',oauth_nonce="'. $nonce . '"' .
            ',oauth_timestamp="' . $timestamp . '"'.
            ',oauth_version="1.0"'.                   
            ',oauth_signature="' . urlencode( $sig ) . '"'
            ;
        return $header;
}
?>