<?php

namespace Services;

use mysqli;
use Exception;

class Database {
    private static $instance = null;
    private $conn;

    private function __construct() {
        $servername = $_ENV['DB_SERVER'];
        $username = $_ENV['DB_USERNAME'];
        $password = $_ENV['DB_PASSWORD'];
        $dbname = $_ENV['DB_NAME'];
        $port = $_ENV['DB_PORT'];

        $this->conn = new mysqli($servername, $username, $password, $dbname, $port);

        if ($this->conn->connect_error) {
            error_log("Error en la conexión a la base de datos: " . $this->conn->connect_error);
            throw new Exception("Error en la conexión a la base de datos: " . $this->conn->connect_error);
        }
    }

    public static function getInstance() {
        if (!self::$instance) {
            self::$instance = new Database();
        }
        return self::$instance;
    }

    public function getConnection() {
        return $this->conn;
    }
}

?>
