<?php

namespace Controllers;
require_once __DIR__ . '/../Services/DonationService.php';

use Services\DonationService;

class DonationController {
    private $donationService;

    public function __construct() {
        $this->donationService = new DonationService();
    }

    // Método para manejar la solicitud de inserción de una donación
    public function createDonation($request) {
        $donationData = [
            'firstName' => $request['firstName'],
            'lastName' => $request['lastName'],
            'amount' => $request['amount'],
            'email' => $request['email'],
            'phone' => $request['phone'],
            'country' => $request['country'],
            'address' => $request['address'],
            'address2' => $request['address2'],
            'zip' => $request['zip'],
            'rfc' => $request['rfc'],
            'city' => $request['city'],
            'state' => $request['state'],
            'taxAddress' => $request['taxAddress'],
            'taxRegime' => $request['taxRegime'],
            'cfdiUsage' => $request['cfdiUsage'],
            'satName' => $request['satName'],
        ];

        $this->donationService->insertDonation($donationData);
    }

    // Método para manejar la solicitud de obtener la última donación
    public function getLastDonation() {
        $lastDonation = $this->donationService->getLastDonation();

        if ($lastDonation) {
            return $lastDonation;
        } else {
            return [
                'message' => 'No se encontró ninguna donación disponible.'
            ];
        }
    }

    public function updateDonation($invoiceId, $donationId) {
        $this->donationService->updateDonation($invoiceId, $donationId);
    }

    public function updateDonationCommission($donationId, $comisionStripe, $docRef) {
        $this->donationService->updateDonationCommission($donationId, $comisionStripe, $docRef);
    }
    public function updateDonationVendorBill($donationId, $vendorBillId) {
        $this->donationService->updateDonationVendorBill($donationId, $vendorBillId);
    }
    public function updateDonationVendorPayment($donationId, $vendorPaymentId) {
        $this->donationService->updateDonationVendorPayment($donationId, $vendorPaymentId);
    }
}

?>
