<?php
ini_set('memory_limit', '256M');
require_once('vendor/autoload.php');
require_once 'secrets.php';
require_once 'models/InvoiceHelper.php';
    require_once 'netsuite/seach.php';
    require_once 'netsuite/crud.php';
    

\Stripe\Stripe::setApiKey($stripeSecretKey);

$payload = @file_get_contents('php://input');
$event = null;
$stripe = new \Stripe\StripeClient($stripeSecretKey);


$usoCfdiList = array(
    -1 => "- Nuevo -",
    25 => "CN01 - Nómina",
    24 => "CP01 - Pagos",
    12 => "D01 - Honorarios Médicos, Dentales y Gastos Hospitalarios",
    13 => "D02 - Gastos Médicos por Incapacidad o Discapacidad",
    14 => "D03 - Gastos Funerales",
    15 => "D04 - Donativos",
    16 => "D05 - Intereses Reales Efectivamente Pagados por Créditos Hipotecarios (Casa Habitación)",
    17 => "D06 - Aportaciones Voluntarias al SAR",
    18 => "D07 - Primas por Seguros de Gastos Médicos",
    19 => "D08 - Gastos de Transportación Escolar Obligatoria",
    20 => "D09 - Depósitos en Cuentas para el Ahorro, Primas que Tengan como Base Planes de Pensiones",
    21 => "D10 - Pagos por Servicios Educativos (Colegiaturas)",
    1 => "G01 - Adquisición de Mercancías",
    2 => "G02 - Devoluciones, Descuentos o Bonificaciones",
    3 => "G03 - Gastos en General",
    4 => "I01 - Construcciones",
    5 => "I02 - Mobiliario y Equipo de Oficina por Inversiones",
    6 => "I03 - Equipo de Transporte",
    7 => "I04 - Equipo de Cómputo y Accesorios",
    8 => "I05 - Dados, Troqueles, Moldes, Matrices y Herramental",
    9 => "I06 - Comunicaciones Telefónicas",
    10 => "I07 - Comunicaciones Satelitales",
    11 => "I08 - Otra Maquinaria y Equipo",
    22 => "P01 - Por Definir",
    23 => "S01 - Sin efectos fiscales"
);

$regimenList = array(
    1 => "601 - General de Ley Personas Morales",
    2 => "603 - Personas Morales con Fines no Lucrativos",
    11 => "605 - Sueldos y Salarios e Ingresos Asimilados a Salarios",
    12 => "606 - Arrendamiento",
    10 => "607 - Régimen de Enajenación o Adquisición de Bienes",
    13 => "608 - Demás ingresos",
    4 => "610 - Residentes en el Extranjero sin Establecimiento Permanente en México",
    14 => "611 - Ingresos por Dividendos (socios y accionistas)",
    15 => "612 - Personas Físicas con Actividades Empresariales y Profesionales",
    16 => "614 - Ingresos por intereses",
    19 => "615 - Régimen de los ingresos por obtención de premios",
    17 => "616 - Sin obligaciones fiscales",
    5 => "620 - Sociedades Cooperativas de Producción que Optan por Diferir sus Ingresos",
    18 => "621 - Incorporación Fiscal",
    6 => "622 - Actividades Agrícolas, Ganaderas, Silvícolas Y Pesqueras",
    7 => "623 - Opcional para Grupos de Sociedades",
    8 => "624 - Coordinados",
    22 => "625 - Régimen de las Actividades Empresariales con ingresos a través de Plataformas Tecnológicas",
    23 => "626 - Régimen Simplificado de Confianza"
);


try {
    $event = \Stripe\Event::constructFrom(
        json_decode($payload, true)
    );
} catch(\UnexpectedValueException $e) {
    // Invalid payload
    http_response_code(400);
    exit();
}
error_log(print_r('event: '.$event->type, TRUE));
// Handle the event
switch ($event->type) {
    case 'checkout.session.completed':
        $session = $event->data->object; 

        // Accede a los metadatos aquí
        $json_data = json_encode($session);
        $escaped_json_data = escapeshellarg($json_data);

        $ruta_archivo_proceso_netsuite = realpath('procesar_netsuite.php');
        $ruta_archivo_proceso_nationbuilder = realpath('procesar_nationbuilder.php');
        
        $archivo_errores_ns = 'errores_ns.txt';
        $archivo_errores_nb = 'errores_nb.txt';

        $jsonData = $session->metadata;

        $flowNS = $jsonData["flowNS"];

        

        

        $entraFlujoNS = false;

        if(isset($flowNS)){
            if($flowNS == "true"){
                error_log(print_r('flowNS: '.$flowNS, TRUE));
                $entraFlujoNS = true;
            }
        }
        $checkoutSession = $event->data->object;
        $metadata = $checkoutSession['metadata'];

        if(isset($metadata['priceId'])){
            $priceId = $metadata['priceId'];
            error_log(print_r('priceId: '.$priceId, TRUE));

            
            // Procesar la sesión de checkout completada
            //error_log(print_r(json_encode($checkoutSession), TRUE)); 

            $paymentIntent = $checkoutSession['payment_intent'];
            $customerId = $checkoutSession['customer'];
            $metadata = $checkoutSession['metadata'];

            $stripe = new \Stripe\StripeClient($stripeSecretKey);
            $data = $stripe->paymentIntents->retrieve(
            $paymentIntent,
            []
            );

            $paymentMethodId = $data['payment_method'];

            $installments = $data['charges']['data'][0]['payment_method_details']['card']['installments'];

            $paymentNew = $stripe->paymentMethods->attach(
                $paymentMethodId,
                ['customer' => $customerId]
              );
        
            $nextYear = strtotime('+1 year');

            $subscription = \Stripe\Subscription::create([
                'customer' => $customerId,
                'items' => [
                    [
                    //'price' => 'price_1NTTlbBlb1fJ8sQqQV01BTah',
                    'price' => $priceId,
                    ],
                ],
                'billing_cycle_anchor' => $nextYear,
                'default_payment_method' => $paymentMethodId,
                'trial_end' => $nextYear
                ]);
                error_log(print_r('subscription: '.json_encode($subscription), TRUE)); 

                if($entraFlujoNS){
                    // Ejecutar el comando en segundo plano con los datos JSON
                    exec("php $ruta_archivo_proceso_netsuite $escaped_json_data >> $archivo_errores_ns 2>&1 &");
                }else{
                    exec("php $ruta_archivo_proceso_nationbuilder $escaped_json_data >> $archivo_errores_nb 2>&1 &");
                }
            
                
        }else{
            if($entraFlujoNS){
                // Ejecutar el comando en segundo plano con los datos JSON
                exec("php $ruta_archivo_proceso_netsuite $escaped_json_data >> $archivo_errores_ns 2>&1 &");
            }else{
                exec("php $ruta_archivo_proceso_nationbuilder $escaped_json_data >> $archivo_errores_nb 2>&1 &");
            }
        }

        

        
        
        http_response_code(200);
    break;

    default:
        http_response_code(200);
        // No hacer nada en otros casos
        break;
}


