<?php
require_once __DIR__ . '/../PHPToolkit/NetSuiteService.php';

function getNexusStates(){
    $service = new NetSuiteService();

    // Crear una búsqueda de estados
    $search = new  NexusSearchBasic();
    $search->country = new SearchEnumMultiSelectField();
    $search->country->operator = "anyOf";
    $search->country->searchValue = "_mexico"; // Por ejemplo: "US" para Estados Unidos

    // Realizar la búsqueda
    $request = new SearchRequest();
    $request->searchRecord = $search;
    $response = $service->search($request);

    // Manejar la respuesta
    if (!$response->searchResult->status->isSuccess) {
        return ['success' => false, 'message' => $response->searchResult->status->statusDetail[0]->message];
    } else {
        $states = [];
        print_r($response->searchResult->recordList);
        foreach ($response->searchResult->recordList->record as $record) {
            $states[] = $record->state; // O el campo que contenga el nombre del estado
        }
        return ['success' => true, 'states' => $states];
    }
}

function updateCustomer(){
    $service = new NetSuiteService();

        $customer = new Customer();

        
        $customer->internalId = 575;

        $addressbookList = new CustomerAddressbookList();
        
        $address = new Address();
        $address->city = "Benito Juárez";
        $address->state = "Ciudad de México";
        $address->country = "_mexico";
        $address->zip = "01030";


        $colonia = new StringCustomFieldRef();
        $colonia->scriptId = "custrecord_colonia";
        $colonia->value = "Portales Oriente";

        $streetName = new StringCustomFieldRef();
        $streetName->scriptId = "custrecord_streetname";
        $streetName->value = "Avenida 123";


        $streetNumber = new StringCustomFieldRef();
        $streetNumber->scriptId = "custrecord_streetnum";
        $streetNumber->value = "1122";


        $customFieldList = new CustomFieldList();
        $customFieldList->customField = array($colonia, $streetName, $streetNumber);


        $address->customFieldList = $customFieldList;

        $addressbook = new CustomerAddressBook();
        $addressbook->addressbookAddress = $address;
        $addressbook->defaultBilling = true;
        $addressbook->defaultShipping = true;

        $addressbookList->addressbook = $addressbook;
        $customer->addressbookList = $addressbookList;

        $request = new UpdateRequest();
        $request->record = $customer;

        $addResponse = $service->update($request);

        if (!$addResponse->writeResponse->status->isSuccess) {
            //echo "ADD ERROR";
            error_log(print_r('error cliente: '.json_encode($addResponse), TRUE));
            return null;
        } else {
            error_log(print_r('cliente: '.$addResponse->writeResponse->baseRef->internalId, TRUE));
            return $addResponse->writeResponse->baseRef->internalId;
            
            //echo "ADD SUCCESS, id " . $addResponse->writeResponse->baseRef->internalId;
        }
}

//$response = getNexusStates();
$response = updateCustomer();
print_r($response);




?>