const stripe = Stripe('pk_test_51KsrHuBlb1fJ8sQqEGMYdD96fYHeBYTvg0AFZwVR9STOf14NOok20PnOFO6srXKEdgCQ1NbPMmMEG7YsClMQ69Vl00ADNdDEEy');

const elements = stripe.elements();
const cardElement = elements.create('card');
cardElement.mount('#card-element');

const cardholderName = document.getElementById('cardholder-name');
const form = document.getElementById('payment-form');

form.addEventListener('submit', async(ev) => {
    ev.preventDefault();
    const { paymentMethod, error } = await stripe.createPaymentMethod(
        'card',
        cardElement, { billing_details: { name: cardholderName.value } },
    );
    if (error) {
        // Show error in payment form
    } else {
        // Send paymentMethod.id to your server (see Step 2)
        const response = await fetch('/pago2.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ payment_method_id: paymentMethod.id }),
        });

        const json = await response.json();

        // Handle server response (see Step 3)
        handleInstallmentPlans(json);
    }
});

const selectPlanForm = document.getElementById('installment-plan-form');
let availablePlans = [];

const handleInstallmentPlans = async(response) => {
    if (response.error) {
        // Show error from server on payment form
    } else {
        // Store the payment intent ID.
        document.getElementById('payment-intent-id').value = response.intent_id;
        availablePlans = response.available_plans;

        // Show available installment options
        availablePlans.forEach((plan, idx) => {
            const newInput = document.getElementById('immediate-plan').cloneNode();
            newInput.setAttribute('value', idx);
            newInput.setAttribute('id', '');
            const label = document.createElement('label');
            label.appendChild(newInput);
            label.appendChild(
                document.createTextNode(`${plan.count} ${plan.interval}s`),
            );

            selectPlanForm.appendChild(label);
        });

        document.getElementById('details').hidden = true;
        document.getElementById('plans').hidden = false;
    }
};

const confirmButton = document.getElementById('confirm-button');

confirmButton.addEventListener('click', async(ev) => {
    const selectedPlanIdx = selectPlanForm.installment_plan.value;
    const selectedPlan = availablePlans[selectedPlanIdx];
    const intentId = document.getElementById('payment-intent-id').value;
    const response = await fetch('/confirm_payment.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
            payment_intent_id: intentId,
            selected_plan: selectedPlan,
        }),
    });

    const responseJson = await response.json();

    // Show success / error response.
    document.getElementById('plans').hidden = true;
    document.getElementById('result').hidden = false;

    var message;
    if (responseJson.status === "succeeded" && selectedPlan !== undefined) {
        message = `Success! You made a charge with this plan:${
      selectedPlan.count
    } ${selectedPlan.interval}`;
    } else if (responseJson.status === "succeeded") {
        message = "Success! You paid immediately!";
    } else {
        message = "Uh oh! Something went wrong";
    }

    document.getElementById("status-message").innerText = message;
});