<?php
// entity/Donation.php
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="donation")
 */
class Donation
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="decimal", precision=10, scale=2, nullable=true)
     */
    private $amount;

    /**
     * @ORM\Column(type="decimal", precision=4, scale=0, nullable=true)
     */
    private $cardnumber;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $firstName;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $lastName;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $email;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $phone;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $country;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $address;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $address2;

    /**
     * @ORM\Column(type="string", length=6, nullable=true)
     */
    private $zip;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $city;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $state;

    /**
     * @ORM\Column(type="string", length=20, nullable=true)
     */
    private $rfc;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $taxAddress;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $taxRegime;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $cfdiUse;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $createdAt;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $statusDonation;

    /**
     * @ORM\Column(type="string", length=50, nullable=true)
     */
    private $customerNetsuite;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $invoiceDate;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $paymentDate;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $invoiceStampDate;

    // Define los getters y setters para todas las propiedades

    // Getter y Setter para "id"
    public function getId(): int
    {
        return $this->id;
    }

    // Getter y Setter para "amount"
    public function getAmount(): float
    {
        return $this->amount;
    }

    public function setAmount(float $amount)
    {
        $this->amount = $amount;
    }

    // Getter y Setter para "cardnumber"
    public function getCardNumber(): int
    {
        return $this->cardnumber;
    }

    public function setCardNumber(int $cardnumber)
    {
        $this->cardnumber = $cardnumber;
    }

    // Getter y Setter para "firstName"
    public function getFirstName(): string
    {
        return $this->firstName;
    }

    public function setFirstName(string $firstName)
    {
        $this->firstName = $firstName;
    }

    // Getter y Setter para "lastName"
    public function getLastName(): string
    {
        return $this->lastName;
    }

    public function setLastName(string $lastName)
    {
        $this->lastName = $lastName;
    }

    // Getter y Setter para "email"
    public function getEmail(): string
    {
        return $this->email;
    }

    public function setEmail(string $email)
    {
        $this->email = $email;
    }

    // Getter y Setter para "phone"
    public function getPhone(): string
    {
        return $this->phone;
    }

    public function setPhone(string $phone)
    {
        $this->phone = $phone;
    }

    // Getter y Setter para "country"
    public function getCountry(): string
    {
        return $this->country;
    }

    public function setCountry(string $country)
    {
        $this->country = $country;
    }

    // Getter y Setter para "address"
    public function getAddress(): string
    {
        return $this->address;
    }

    public function setAddress(string $address)
    {
        $this->address = $address;
    }

    // Getter y Setter para "address2"
    public function getAddress2(): string
    {
        return $this->address2;
    }

    public function setAddress2(string $address2)
    {
        $this->address2 = $address2;
    }

    // Getter y Setter para "zip"
    public function getZip(): string
    {
        return $this->zip;
    }

    public function setZip(string $zip)
    {
        $this->zip = $zip;
    }

    // Getter y Setter para "city"
    public function getCity(): string
    {
        return $this->city;
    }

    public function setCity(string $city)
    {
        $this->city = $city;
    }

    // Getter y Setter para "state"
    public function getState(): string
    {
        return $this->state;
    }

    public function setState(string $state)
    {
        $this->state = $state;
    }

    // Getter y Setter para "rfc"
    public function getRfc(): string
    {
        return $this->rfc;
    }

    public function setRfc(string $rfc)
    {
        $this->rfc = $rfc;
    }

    // Getter y Setter para "taxAddress"
    public function getTaxAddress(): string
    {
        return $this->taxAddress;
    }

    public function setTaxAddress(string $taxAddress)
    {
        $this->taxAddress = $taxAddress;
    }

    // Getter y Setter para "taxRegime"
    public function getTaxRegime(): string
    {
        return $this->taxRegime;
    }

    public function setTaxRegime(string $taxRegime)
    {
        $this->taxRegime = $taxRegime;
    }

    // Getter y Setter para "cfdiUse"
    public function getCfdiUse(): string
    {
        return $this->cfdiUse;
    }

    public function setCfdiUse(string $cfdiUse)
    {
        $this->cfdiUse = $cfdiUse;
    }

    // Getter y Setter para "createdAt"
    public function getCreatedAt(): DateTime
    {
        return $this->createdAt;
    }

    public function setCreatedAt(DateTime $createdAt)
    {
        $this->createdAt = $createdAt;
    }

    // Getter y Setter para "statusDonation"
    public function getStatusDonation(): int
    {
        return $this->statusDonation;
    }

    public function setStatusDonation(int $statusDonation)
    {
        $this->statusDonation = $statusDonation;
    }

    // Getter y Setter para "customerNetsuite"
    public function getCustomerNetsuite(): string
    {
        return $this->customerNetsuite;
    }

    public function setCustomerNetsuite(string $customerNetsuite)
    {
        $this->customerNetsuite = $customerNetsuite;
    }

    // Getter y Setter para "invoiceDate"
    public function getInvoiceDate(): DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(DateTime $invoiceDate)
    {
        $this->invoiceDate = $invoiceDate;
    }

    // Getter y Setter para "paymentDate"
    public function getPaymentDate(): DateTime
    {
        return $this->paymentDate;
    }

    public function setPaymentDate(DateTime $paymentDate)
    {
        $this->paymentDate = $paymentDate;
    }

    // Getter y Setter para "invoiceStampDate"
    public function getInvoiceStampDate(): DateTime
    {
        return $this->invoiceStampDate;
    }

    public function setInvoiceStampDate(DateTime $invoiceStampDate)
    {
        $this->invoiceStampDate = $invoiceStampDate;
    }

    // ... Define los getters y setters para todas las demás propiedades
}
